/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.datasync.net;

import dev.upcraft.datasync.DataSyncMod;
import dev.upcraft.datasync.api.DataSyncAPI;
import dev.upcraft.datasync.content.DataRegistry;
import dev.upcraft.datasync.content.DataStore;
import dev.upcraft.datasync.content.DataType;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public record S2CUpdatePlayerDataPacket(UUID targetId, @Nullable class_2960 dataTypeId) implements FabricPacket
{
    public static final class_2960 ID = DataSyncMod.id("s2c_update_player_data");
    public static final PacketType<S2CUpdatePlayerDataPacket> TYPE = PacketType.create((class_2960)ID, S2CUpdatePlayerDataPacket::fromNetwork);

    public boolean refreshAll() {
        return this.dataTypeId() == null;
    }

    public static void send(class_3222 p, UUID origin, @Nullable class_2960 id) {
        if (ServerPlayNetworking.canSend((class_3222)p, TYPE)) {
            ServerPlayNetworking.send((class_3222)p, (FabricPacket)new S2CUpdatePlayerDataPacket(origin, id));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void handle(class_746 localPlayer, PacketSender packetSender) {
        if (this.refreshAll()) {
            DataSyncAPI.refreshAllPlayerData(this.targetId());
            return;
        }
        DataType<?> type = DataRegistry.getById(this.dataTypeId());
        if (type == null) {
            DataSyncMod.LOGGER.debug("Ignoring incoming sync packet for unknown data type: '{}' from player {}", (Object)this.dataTypeId(), (Object)this.targetId());
            return;
        }
        DataStore.getPlayerLookup(this.targetId, type).reload();
    }

    private static S2CUpdatePlayerDataPacket fromNetwork(class_2540 friendlyByteBuf) {
        UUID targetId = friendlyByteBuf.method_10790();
        boolean single = friendlyByteBuf.readBoolean();
        class_2960 dataType = null;
        if (single) {
            dataType = friendlyByteBuf.method_10810();
        }
        return new S2CUpdatePlayerDataPacket(targetId, dataType);
    }

    public void write(class_2540 buf) {
        buf.method_10797(this.targetId());
        if (this.dataTypeId() != null) {
            buf.writeBoolean(true);
            buf.method_10812(this.dataTypeId());
        } else {
            buf.writeBoolean(false);
        }
    }

    public PacketType<?> getType() {
        return TYPE;
    }
}

